from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.upload_request_mime_type import UploadRequestMimeType

T = TypeVar("T", bound="UploadRequest")


@_attrs_define
class UploadRequest:
    """File Upload Request

    Attributes:
        file_name (str):  Example: readme.txt.
        mime_type (UploadRequestMimeType):  Example: text/plain.
    """

    file_name: str
    mime_type: UploadRequestMimeType
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        file_name = self.file_name

        mime_type = self.mime_type.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "fileName": file_name,
                "mimeType": mime_type,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        file_name = d.pop("fileName")

        mime_type = UploadRequestMimeType(d.pop("mimeType"))

        upload_request = cls(
            file_name=file_name,
            mime_type=mime_type,
        )

        upload_request.additional_properties = d
        return upload_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
