from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.upload_description import UploadDescription


T = TypeVar("T", bound="RegisterForTransferResponse")


@_attrs_define
class RegisterForTransferResponse:
    """Result of the RegisterForTransfer-operation

    Attributes:
        user_context_id (UUID): ID of the new user-context
        token (str): The token to accept the invitation
        upload (list['UploadDescription']):
    """

    user_context_id: UUID
    token: str
    upload: list["UploadDescription"]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        user_context_id = str(self.user_context_id)

        token = self.token

        upload = []
        for upload_item_data in self.upload:
            upload_item = upload_item_data.to_dict()
            upload.append(upload_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "userContextId": user_context_id,
                "token": token,
                "upload": upload,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.upload_description import UploadDescription

        d = dict(src_dict)
        user_context_id = UUID(d.pop("userContextId"))

        token = d.pop("token")

        upload = []
        _upload = d.pop("upload")
        for upload_item_data in _upload:
            upload_item = UploadDescription.from_dict(upload_item_data)

            upload.append(upload_item)

        register_for_transfer_response = cls(
            user_context_id=user_context_id,
            token=token,
            upload=upload,
        )

        register_for_transfer_response.additional_properties = d
        return register_for_transfer_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
