import datetime
from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.label_type import LabelType


T = TypeVar("T", bound="Label")


@_attrs_define
class Label:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'labelType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'string', 'name': 'string', 'description': 'string', 'nameOfIssuer': 'string'}, 'dateOfIssue':
            '2019-08-24', 'validToDate': '2019-08-24'}]

    Attributes:
        id (Union[Unset, UUID]):
        label_type (Union[Unset, LabelType]):
        date_of_issue (Union[Unset, datetime.date]):
        valid_to_date (Union[Unset, datetime.date]):
    """

    id: Union[Unset, UUID] = UNSET
    label_type: Union[Unset, "LabelType"] = UNSET
    date_of_issue: Union[Unset, datetime.date] = UNSET
    valid_to_date: Union[Unset, datetime.date] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        label_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.label_type, Unset):
            label_type = self.label_type.to_dict()

        date_of_issue: Union[Unset, str] = UNSET
        if not isinstance(self.date_of_issue, Unset):
            date_of_issue = self.date_of_issue.isoformat()

        valid_to_date: Union[Unset, str] = UNSET
        if not isinstance(self.valid_to_date, Unset):
            valid_to_date = self.valid_to_date.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if label_type is not UNSET:
            field_dict["labelType"] = label_type
        if date_of_issue is not UNSET:
            field_dict["dateOfIssue"] = date_of_issue
        if valid_to_date is not UNSET:
            field_dict["validToDate"] = valid_to_date

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.label_type import LabelType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _label_type = d.pop("labelType", UNSET)
        label_type: Union[Unset, LabelType]
        if isinstance(_label_type, Unset):
            label_type = UNSET
        else:
            label_type = LabelType.from_dict(_label_type)

        _date_of_issue = d.pop("dateOfIssue", UNSET)
        date_of_issue: Union[Unset, datetime.date]
        if isinstance(_date_of_issue, Unset):
            date_of_issue = UNSET
        else:
            date_of_issue = isoparse(_date_of_issue).date()

        _valid_to_date = d.pop("validToDate", UNSET)
        valid_to_date: Union[Unset, datetime.date]
        if isinstance(_valid_to_date, Unset):
            valid_to_date = UNSET
        else:
            valid_to_date = isoparse(_valid_to_date).date()

        label = cls(
            id=id,
            label_type=label_type,
            date_of_issue=date_of_issue,
            valid_to_date=valid_to_date,
        )

        label.additional_properties = d
        return label

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
