from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.key_object_value_number_key import KeyObjectValueNumberKey


T = TypeVar("T", bound="KeyObjectValueNumber")


@_attrs_define
class KeyObjectValueNumber:
    """
    Attributes:
        key (Union[Unset, KeyObjectValueNumberKey]):
        value (Union[Unset, float]):
    """

    key: Union[Unset, "KeyObjectValueNumberKey"] = UNSET
    value: Union[Unset, float] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        key: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.key, Unset):
            key = self.key.to_dict()

        value = self.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if key is not UNSET:
            field_dict["key"] = key
        if value is not UNSET:
            field_dict["value"] = value

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.key_object_value_number_key import KeyObjectValueNumberKey

        d = dict(src_dict)
        _key = d.pop("key", UNSET)
        key: Union[Unset, KeyObjectValueNumberKey]
        if isinstance(_key, Unset):
            key = UNSET
        else:
            key = KeyObjectValueNumberKey.from_dict(_key)

        value = d.pop("value", UNSET)

        key_object_value_number = cls(
            key=key,
            value=value,
        )

        key_object_value_number.additional_properties = d
        return key_object_value_number

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
