from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.key_string_value_string import KeyStringValueString


T = TypeVar("T", bound="ItemTypeComplex")


@_attrs_define
class ItemTypeComplex:
    """
    Attributes:
        id (Union[Unset, UUID]):
        code (Union[Unset, str]):
        name (Union[Unset, str]):
        description (Union[Unset, str]):
        add_fields (Union[Unset, list['KeyStringValueString']]):
    """

    id: Union[Unset, UUID] = UNSET
    code: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    description: Union[Unset, str] = UNSET
    add_fields: Union[Unset, list["KeyStringValueString"]] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        code = self.code

        name = self.name

        description = self.description

        add_fields: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.add_fields, Unset):
            add_fields = []
            for add_fields_item_data in self.add_fields:
                add_fields_item = add_fields_item_data.to_dict()
                add_fields.append(add_fields_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if code is not UNSET:
            field_dict["code"] = code
        if name is not UNSET:
            field_dict["name"] = name
        if description is not UNSET:
            field_dict["description"] = description
        if add_fields is not UNSET:
            field_dict["addFields"] = add_fields

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.key_string_value_string import KeyStringValueString

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        code = d.pop("code", UNSET)

        name = d.pop("name", UNSET)

        description = d.pop("description", UNSET)

        add_fields = []
        _add_fields = d.pop("addFields", UNSET)
        for add_fields_item_data in _add_fields or []:
            add_fields_item = KeyStringValueString.from_dict(add_fields_item_data)

            add_fields.append(add_fields_item)

        item_type_complex = cls(
            id=id,
            code=code,
            name=name,
            description=description,
            add_fields=add_fields,
        )

        item_type_complex.additional_properties = d
        return item_type_complex

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
