from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="FitOutStandard")


@_attrs_define
class FitOutStandard:
    """
    Attributes:
        id (Union[Unset, UUID]):
        fit_out_standard_value (Union[Unset, ItemType]):
    """

    id: Union[Unset, UUID] = UNSET
    fit_out_standard_value: Union[Unset, "ItemType"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        fit_out_standard_value: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.fit_out_standard_value, Unset):
            fit_out_standard_value = self.fit_out_standard_value.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if fit_out_standard_value is not UNSET:
            field_dict["fitOutStandardValue"] = fit_out_standard_value

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _fit_out_standard_value = d.pop("fitOutStandardValue", UNSET)
        fit_out_standard_value: Union[Unset, ItemType]
        if isinstance(_fit_out_standard_value, Unset):
            fit_out_standard_value = UNSET
        else:
            fit_out_standard_value = ItemType.from_dict(_fit_out_standard_value)

        fit_out_standard = cls(
            id=id,
            fit_out_standard_value=fit_out_standard_value,
        )

        fit_out_standard.additional_properties = d
        return fit_out_standard

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
