import datetime
from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.file_description import FileDescription


T = TypeVar("T", bound="FileGetDescription")


@_attrs_define
class FileGetDescription:
    """
    Attributes:
        download_url (str): Url where the binaries can be downloaded
        download_url_valid_until (datetime.datetime): Timestamp until when the downloadUrl is working. After this
            timestamp a new url has to be retrieved.
        file_description (Union[Unset, FileDescription]):
    """

    download_url: str
    download_url_valid_until: datetime.datetime
    file_description: Union[Unset, "FileDescription"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        download_url = self.download_url

        download_url_valid_until = self.download_url_valid_until.isoformat()

        file_description: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.file_description, Unset):
            file_description = self.file_description.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "downloadUrl": download_url,
                "downloadUrlValidUntil": download_url_valid_until,
            }
        )
        if file_description is not UNSET:
            field_dict["fileDescription"] = file_description

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.file_description import FileDescription

        d = dict(src_dict)
        download_url = d.pop("downloadUrl")

        download_url_valid_until = isoparse(d.pop("downloadUrlValidUntil"))

        _file_description = d.pop("fileDescription", UNSET)
        file_description: Union[Unset, FileDescription]
        if isinstance(_file_description, Unset):
            file_description = UNSET
        else:
            file_description = FileDescription.from_dict(_file_description)

        file_get_description = cls(
            download_url=download_url,
            download_url_valid_until=download_url_valid_until,
            file_description=file_description,
        )

        file_get_description.additional_properties = d
        return file_get_description

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
