from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.physical_unit import PhysicalUnit
    from ..models.ressource_chemical_substance import RessourceChemicalSubstance


T = TypeVar("T", bound="EnvironmentImpactUnit")


@_attrs_define
class EnvironmentImpactUnit:
    """
    Attributes:
        id (Union[Unset, UUID]):
        name (Union[Unset, str]):
        description (Union[Unset, str]):
        physical_unit (Union[Unset, PhysicalUnit]):  Example: [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code':
            'kWh', 'name': 'Kilowattstunde', 'description': 'Energiemasseinheit, Kilowattstunde (kWh).'}, {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'L', 'name': 'Liter', 'description': 'Volumengrösse, Liter'},
            {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 't', 'name': 'Tonne', 'description': 'Gewichtseinheit,
            Tonne.'}].
        ressource_chemical_substance (Union[Unset, RessourceChemicalSubstance]):  Example: [{'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht', 'description': 'Heizöl für
            den privatne Gebraucht, Extra Leicht'}, {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'CO2', 'name':
            'Kohlenstoffdioxid', 'description': 'Nicht brennbares, saures und farbloses Gas.'}].
        unit (Union[Unset, str]):
    """

    id: Union[Unset, UUID] = UNSET
    name: Union[Unset, str] = UNSET
    description: Union[Unset, str] = UNSET
    physical_unit: Union[Unset, "PhysicalUnit"] = UNSET
    ressource_chemical_substance: Union[Unset, "RessourceChemicalSubstance"] = UNSET
    unit: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        name = self.name

        description = self.description

        physical_unit: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.physical_unit, Unset):
            physical_unit = self.physical_unit.to_dict()

        ressource_chemical_substance: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.ressource_chemical_substance, Unset):
            ressource_chemical_substance = self.ressource_chemical_substance.to_dict()

        unit = self.unit

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if name is not UNSET:
            field_dict["name"] = name
        if description is not UNSET:
            field_dict["description"] = description
        if physical_unit is not UNSET:
            field_dict["physicalUnit"] = physical_unit
        if ressource_chemical_substance is not UNSET:
            field_dict["ressourceChemicalSubstance"] = ressource_chemical_substance
        if unit is not UNSET:
            field_dict["unit"] = unit

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.physical_unit import PhysicalUnit
        from ..models.ressource_chemical_substance import RessourceChemicalSubstance

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        name = d.pop("name", UNSET)

        description = d.pop("description", UNSET)

        _physical_unit = d.pop("physicalUnit", UNSET)
        physical_unit: Union[Unset, PhysicalUnit]
        if isinstance(_physical_unit, Unset):
            physical_unit = UNSET
        else:
            physical_unit = PhysicalUnit.from_dict(_physical_unit)

        _ressource_chemical_substance = d.pop("ressourceChemicalSubstance", UNSET)
        ressource_chemical_substance: Union[Unset, RessourceChemicalSubstance]
        if isinstance(_ressource_chemical_substance, Unset):
            ressource_chemical_substance = UNSET
        else:
            ressource_chemical_substance = RessourceChemicalSubstance.from_dict(_ressource_chemical_substance)

        unit = d.pop("unit", UNSET)

        environment_impact_unit = cls(
            id=id,
            name=name,
            description=description,
            physical_unit=physical_unit,
            ressource_chemical_substance=ressource_chemical_substance,
            unit=unit,
        )

        environment_impact_unit.additional_properties = d
        return environment_impact_unit

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
