from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.environment_impact_unit import EnvironmentImpactUnit


T = TypeVar("T", bound="EnvironmentImpact")


@_attrs_define
class EnvironmentImpact:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'environmentImpactUnit': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'name': 'string', 'description': 'string', 'physicalUnit': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'kWh', 'name': 'Kilowattstunde', 'description':
            'Energiemasseinheit, Kilowattstunde (kWh).'}, 'ressourceChemicalSubstance': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht', 'description': 'Heizöl für
            den privatne Gebraucht, Extra Leicht'}, 'unit': 'string'}, 'impactValue': 0}]

    Attributes:
        id (Union[Unset, UUID]):
        environment_impact_unit (Union[Unset, EnvironmentImpactUnit]):
        impact_value (Union[Unset, float]):
    """

    id: Union[Unset, UUID] = UNSET
    environment_impact_unit: Union[Unset, "EnvironmentImpactUnit"] = UNSET
    impact_value: Union[Unset, float] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        environment_impact_unit: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.environment_impact_unit, Unset):
            environment_impact_unit = self.environment_impact_unit.to_dict()

        impact_value = self.impact_value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if environment_impact_unit is not UNSET:
            field_dict["environmentImpactUnit"] = environment_impact_unit
        if impact_value is not UNSET:
            field_dict["impactValue"] = impact_value

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.environment_impact_unit import EnvironmentImpactUnit

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _environment_impact_unit = d.pop("environmentImpactUnit", UNSET)
        environment_impact_unit: Union[Unset, EnvironmentImpactUnit]
        if isinstance(_environment_impact_unit, Unset):
            environment_impact_unit = UNSET
        else:
            environment_impact_unit = EnvironmentImpactUnit.from_dict(_environment_impact_unit)

        impact_value = d.pop("impactValue", UNSET)

        environment_impact = cls(
            id=id,
            environment_impact_unit=environment_impact_unit,
            impact_value=impact_value,
        )

        environment_impact.additional_properties = d
        return environment_impact

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
