from collections.abc import Mapping
from typing import Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="Entrance")


@_attrs_define
class Entrance:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'egid': 'string', 'egaid': 'string', 'deinr': 'string', 'esid':
            'string'}]

    Attributes:
        id (Union[Unset, UUID]):
        egid (Union[Unset, str]): Federal Entry Identifier ("Eidgenössischer Eingangsidentifikator"), see:
            https://www.cadastre.ch/de/manual-av/topic/address.html
        egaid (Union[Unset, str]): Federal Building Address Identifier ("Eidgenössischer Gebäudeadressidentifikator"),
            see https://www.housing-stat.ch/files/Merkmalsliste_de.pdf
        deinr (Union[Unset, str]): Federal Entrance Number Building ("Eidgenössische Eingangsnummer Gebäude"), see
            https://www.housing-stat.ch/files/Merkmalsliste_de.pdf
        esid (Union[Unset, str]): Federal Road Identifier ("Eidgenössische Strassenidentifikator"), see
            https://www.housing-stat.ch/files/Merkmalsliste_de.pdf
    """

    id: Union[Unset, UUID] = UNSET
    egid: Union[Unset, str] = UNSET
    egaid: Union[Unset, str] = UNSET
    deinr: Union[Unset, str] = UNSET
    esid: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        egid = self.egid

        egaid = self.egaid

        deinr = self.deinr

        esid = self.esid

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if egid is not UNSET:
            field_dict["egid"] = egid
        if egaid is not UNSET:
            field_dict["egaid"] = egaid
        if deinr is not UNSET:
            field_dict["deinr"] = deinr
        if esid is not UNSET:
            field_dict["esid"] = esid

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        egid = d.pop("egid", UNSET)

        egaid = d.pop("egaid", UNSET)

        deinr = d.pop("deinr", UNSET)

        esid = d.pop("esid", UNSET)

        entrance = cls(
            id=id,
            egid=egid,
            egaid=egaid,
            deinr=deinr,
            esid=esid,
        )

        entrance.additional_properties = d
        return entrance

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
