from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Document")


@_attrs_define
class Document:
    """
    Attributes:
        id (Union[Unset, UUID]):
        document_type (Union[Unset, ItemType]):
        iso_3_language (Union[Unset, str]): Content language of the document, if the document contains text. Default is
            deu. Example: ['eng'].
        document_ref (Union[Unset, UUID]):
        remark (Union[Unset, str]):
    """

    id: Union[Unset, UUID] = UNSET
    document_type: Union[Unset, "ItemType"] = UNSET
    iso_3_language: Union[Unset, str] = UNSET
    document_ref: Union[Unset, UUID] = UNSET
    remark: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        document_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.document_type, Unset):
            document_type = self.document_type.to_dict()

        iso_3_language = self.iso_3_language

        document_ref: Union[Unset, str] = UNSET
        if not isinstance(self.document_ref, Unset):
            document_ref = str(self.document_ref)

        remark = self.remark

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if document_type is not UNSET:
            field_dict["documentType"] = document_type
        if iso_3_language is not UNSET:
            field_dict["iso3Language"] = iso_3_language
        if document_ref is not UNSET:
            field_dict["documentRef"] = document_ref
        if remark is not UNSET:
            field_dict["remark"] = remark

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _document_type = d.pop("documentType", UNSET)
        document_type: Union[Unset, ItemType]
        if isinstance(_document_type, Unset):
            document_type = UNSET
        else:
            document_type = ItemType.from_dict(_document_type)

        iso_3_language = d.pop("iso3Language", UNSET)

        _document_ref = d.pop("documentRef", UNSET)
        document_ref: Union[Unset, UUID]
        if isinstance(_document_ref, Unset):
            document_ref = UNSET
        else:
            document_ref = UUID(_document_ref)

        remark = d.pop("remark", UNSET)

        document = cls(
            id=id,
            document_type=document_type,
            iso_3_language=iso_3_language,
            document_ref=document_ref,
            remark=remark,
        )

        document.additional_properties = d
        return document

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
