from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.format_type import FormatType
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Coordinates")


@_attrs_define
class Coordinates:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'coordinates': 'string', 'referenceType': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string', 'description': 'string'},
            'formatType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string', 'description':
            'string', 'format': 'string'}}]

    Attributes:
        id (Union[Unset, UUID]):
        coordinates (Union[Unset, str]):
        reference_type (Union[Unset, ItemType]):
        format_type (Union[Unset, FormatType]):
    """

    id: Union[Unset, UUID] = UNSET
    coordinates: Union[Unset, str] = UNSET
    reference_type: Union[Unset, "ItemType"] = UNSET
    format_type: Union[Unset, "FormatType"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        coordinates = self.coordinates

        reference_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.reference_type, Unset):
            reference_type = self.reference_type.to_dict()

        format_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.format_type, Unset):
            format_type = self.format_type.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if coordinates is not UNSET:
            field_dict["coordinates"] = coordinates
        if reference_type is not UNSET:
            field_dict["referenceType"] = reference_type
        if format_type is not UNSET:
            field_dict["formatType"] = format_type

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.format_type import FormatType
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        coordinates = d.pop("coordinates", UNSET)

        _reference_type = d.pop("referenceType", UNSET)
        reference_type: Union[Unset, ItemType]
        if isinstance(_reference_type, Unset):
            reference_type = UNSET
        else:
            reference_type = ItemType.from_dict(_reference_type)

        _format_type = d.pop("formatType", UNSET)
        format_type: Union[Unset, FormatType]
        if isinstance(_format_type, Unset):
            format_type = UNSET
        else:
            format_type = FormatType.from_dict(_format_type)

        coordinates = cls(
            id=id,
            coordinates=coordinates,
            reference_type=reference_type,
            format_type=format_type,
        )

        coordinates.additional_properties = d
        return coordinates

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
