import datetime
from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Condition")


@_attrs_define
class Condition:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'conditionValue': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'string', 'name': 'string', 'description': 'string', 'groupMemberOf': [{'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string', 'description': 'string'}]},
            'dateCreatedPurchased': '2023-01-25', 'dateRenovated': '2023-01-25', 'dateOfDisassembly': '2023-01-25',
            'renovationType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string',
            'description': 'string', 'groupMemberOf': [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string',
            'name': 'string', 'description': 'string'}]}, 'lifetimeInYears': 10, 'acquisitionCosts': 0,
            'acquisitionCostsIsoCurrency': 'str', 'lastRenovationCosts': 0, 'lastRenovationCostsIsoCurrency': 'str',
            'dateLastMaintenance': '2019-08-24'}]

    Attributes:
        condition_value (ItemType):
        id (Union[Unset, UUID]):
        date_created_purchased (Union[Unset, datetime.date]):  Example: ['2023-01-25'].
        date_renovated (Union[Unset, datetime.date]):  Example: ['2023-01-25'].
        date_of_disassembly (Union[Unset, datetime.date]):  Example: ['2023-01-25'].
        renovation_type (Union[Unset, ItemType]):
        lifetime_in_years (Union[Unset, int]):  Example: [10].
        acquisition_costs (Union[Unset, float]):
        acquisition_costs_iso_currency (Union[Unset, str]):
        last_renovation_costs (Union[Unset, float]):
        last_renovation_costs_iso_currency (Union[Unset, str]):
        date_last_maintenance (Union[Unset, datetime.date]):
    """

    condition_value: "ItemType"
    id: Union[Unset, UUID] = UNSET
    date_created_purchased: Union[Unset, datetime.date] = UNSET
    date_renovated: Union[Unset, datetime.date] = UNSET
    date_of_disassembly: Union[Unset, datetime.date] = UNSET
    renovation_type: Union[Unset, "ItemType"] = UNSET
    lifetime_in_years: Union[Unset, int] = UNSET
    acquisition_costs: Union[Unset, float] = UNSET
    acquisition_costs_iso_currency: Union[Unset, str] = UNSET
    last_renovation_costs: Union[Unset, float] = UNSET
    last_renovation_costs_iso_currency: Union[Unset, str] = UNSET
    date_last_maintenance: Union[Unset, datetime.date] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        condition_value = self.condition_value.to_dict()

        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        date_created_purchased: Union[Unset, str] = UNSET
        if not isinstance(self.date_created_purchased, Unset):
            date_created_purchased = self.date_created_purchased.isoformat()

        date_renovated: Union[Unset, str] = UNSET
        if not isinstance(self.date_renovated, Unset):
            date_renovated = self.date_renovated.isoformat()

        date_of_disassembly: Union[Unset, str] = UNSET
        if not isinstance(self.date_of_disassembly, Unset):
            date_of_disassembly = self.date_of_disassembly.isoformat()

        renovation_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.renovation_type, Unset):
            renovation_type = self.renovation_type.to_dict()

        lifetime_in_years = self.lifetime_in_years

        acquisition_costs = self.acquisition_costs

        acquisition_costs_iso_currency = self.acquisition_costs_iso_currency

        last_renovation_costs = self.last_renovation_costs

        last_renovation_costs_iso_currency = self.last_renovation_costs_iso_currency

        date_last_maintenance: Union[Unset, str] = UNSET
        if not isinstance(self.date_last_maintenance, Unset):
            date_last_maintenance = self.date_last_maintenance.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "conditionValue": condition_value,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if date_created_purchased is not UNSET:
            field_dict["dateCreatedPurchased"] = date_created_purchased
        if date_renovated is not UNSET:
            field_dict["dateRenovated"] = date_renovated
        if date_of_disassembly is not UNSET:
            field_dict["dateOfDisassembly"] = date_of_disassembly
        if renovation_type is not UNSET:
            field_dict["renovationType"] = renovation_type
        if lifetime_in_years is not UNSET:
            field_dict["lifetimeInYears"] = lifetime_in_years
        if acquisition_costs is not UNSET:
            field_dict["acquisitionCosts"] = acquisition_costs
        if acquisition_costs_iso_currency is not UNSET:
            field_dict["acquisitionCostsIsoCurrency"] = acquisition_costs_iso_currency
        if last_renovation_costs is not UNSET:
            field_dict["lastRenovationCosts"] = last_renovation_costs
        if last_renovation_costs_iso_currency is not UNSET:
            field_dict["lastRenovationCostsIsoCurrency"] = last_renovation_costs_iso_currency
        if date_last_maintenance is not UNSET:
            field_dict["dateLastMaintenance"] = date_last_maintenance

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        condition_value = ItemType.from_dict(d.pop("conditionValue"))

        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _date_created_purchased = d.pop("dateCreatedPurchased", UNSET)
        date_created_purchased: Union[Unset, datetime.date]
        if isinstance(_date_created_purchased, Unset):
            date_created_purchased = UNSET
        else:
            date_created_purchased = isoparse(_date_created_purchased).date()

        _date_renovated = d.pop("dateRenovated", UNSET)
        date_renovated: Union[Unset, datetime.date]
        if isinstance(_date_renovated, Unset):
            date_renovated = UNSET
        else:
            date_renovated = isoparse(_date_renovated).date()

        _date_of_disassembly = d.pop("dateOfDisassembly", UNSET)
        date_of_disassembly: Union[Unset, datetime.date]
        if isinstance(_date_of_disassembly, Unset):
            date_of_disassembly = UNSET
        else:
            date_of_disassembly = isoparse(_date_of_disassembly).date()

        _renovation_type = d.pop("renovationType", UNSET)
        renovation_type: Union[Unset, ItemType]
        if isinstance(_renovation_type, Unset):
            renovation_type = UNSET
        else:
            renovation_type = ItemType.from_dict(_renovation_type)

        lifetime_in_years = d.pop("lifetimeInYears", UNSET)

        acquisition_costs = d.pop("acquisitionCosts", UNSET)

        acquisition_costs_iso_currency = d.pop("acquisitionCostsIsoCurrency", UNSET)

        last_renovation_costs = d.pop("lastRenovationCosts", UNSET)

        last_renovation_costs_iso_currency = d.pop("lastRenovationCostsIsoCurrency", UNSET)

        _date_last_maintenance = d.pop("dateLastMaintenance", UNSET)
        date_last_maintenance: Union[Unset, datetime.date]
        if isinstance(_date_last_maintenance, Unset):
            date_last_maintenance = UNSET
        else:
            date_last_maintenance = isoparse(_date_last_maintenance).date()

        condition = cls(
            condition_value=condition_value,
            id=id,
            date_created_purchased=date_created_purchased,
            date_renovated=date_renovated,
            date_of_disassembly=date_of_disassembly,
            renovation_type=renovation_type,
            lifetime_in_years=lifetime_in_years,
            acquisition_costs=acquisition_costs,
            acquisition_costs_iso_currency=acquisition_costs_iso_currency,
            last_renovation_costs=last_renovation_costs,
            last_renovation_costs_iso_currency=last_renovation_costs_iso_currency,
            date_last_maintenance=date_last_maintenance,
        )

        condition.additional_properties = d
        return condition

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
