from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType
    from ..models.key_object_value_number import KeyObjectValueNumber


T = TypeVar("T", bound="CalculationResult")


@_attrs_define
class CalculationResult:
    """
    Attributes:
        id (Union[Unset, UUID]): Id of the Calculation.
        object_ (Union[Unset, str]): Object name on which the caluclation is based.
        type_ (Union[Unset, ItemType]):
        results (Union[Unset, list['KeyObjectValueNumber']]):
    """

    id: Union[Unset, UUID] = UNSET
    object_: Union[Unset, str] = UNSET
    type_: Union[Unset, "ItemType"] = UNSET
    results: Union[Unset, list["KeyObjectValueNumber"]] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        object_ = self.object_

        type_: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.type_, Unset):
            type_ = self.type_.to_dict()

        results: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.results, Unset):
            results = []
            for results_item_data in self.results:
                results_item = results_item_data.to_dict()
                results.append(results_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if object_ is not UNSET:
            field_dict["object"] = object_
        if type_ is not UNSET:
            field_dict["type"] = type_
        if results is not UNSET:
            field_dict["results"] = results

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType
        from ..models.key_object_value_number import KeyObjectValueNumber

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        object_ = d.pop("object", UNSET)

        _type_ = d.pop("type", UNSET)
        type_: Union[Unset, ItemType]
        if isinstance(_type_, Unset):
            type_ = UNSET
        else:
            type_ = ItemType.from_dict(_type_)

        results = []
        _results = d.pop("results", UNSET)
        for results_item_data in _results or []:
            results_item = KeyObjectValueNumber.from_dict(results_item_data)

            results.append(results_item)

        calculation_result = cls(
            id=id,
            object_=object_,
            type_=type_,
            results=results,
        )

        calculation_result.additional_properties = d
        return calculation_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
