from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="BuildingPart")


@_attrs_define
class BuildingPart:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'buildingPartType': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string', 'description': 'string',
            'groupMemberOf': [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string',
            'description': 'string'}]}}]

    Attributes:
        id (Union[Unset, UUID]):
        building_part_type (Union[Unset, ItemType]):
    """

    id: Union[Unset, UUID] = UNSET
    building_part_type: Union[Unset, "ItemType"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        building_part_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.building_part_type, Unset):
            building_part_type = self.building_part_type.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if building_part_type is not UNSET:
            field_dict["buildingPartType"] = building_part_type

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _building_part_type = d.pop("buildingPartType", UNSET)
        building_part_type: Union[Unset, ItemType]
        if isinstance(_building_part_type, Unset):
            building_part_type = UNSET
        else:
            building_part_type = ItemType.from_dict(_building_part_type)

        building_part = cls(
            id=id,
            building_part_type=building_part_type,
        )

        building_part.additional_properties = d
        return building_part

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
