from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Building")


@_attrs_define
class Building:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'egid': 'string', 'plotId':
            'ef535cb1-61ae-4034-af79-9bdd6b359726', 'buildingType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code':
            'string', 'name': 'string', 'description': 'string', 'groupMemberOf': [{'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string', 'description': 'string'}]},
            'buildingClass': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string', 'name': 'string',
            'description': 'string', 'groupMemberOf': [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'string',
            'name': 'string', 'description': 'string'}]}, 'heightInMeters': 0, 'groundAreaInM2': 0, 'livingAreaInM2': 0,
            'cubicVolumeInM3': 0, 'numberOfapartments': 0, 'numberOfFloors': 0, 'roofAreaInM2': 0, 'facadeAreaInM2': 0}]

    Attributes:
        building_type (ItemType):
        id (Union[Unset, UUID]):
        egid (Union[Unset, float]): External identifier for a building. See
            https://www.bfs.admin.ch/bfs/de/home/register/personenregister/registerharmonisierung/egid-ewid.html
        plot_id (Union[Unset, UUID]): Id of the Plot the Building is build on.
        building_class (Union[Unset, ItemType]):
        height_in_meters (Union[Unset, float]):
        ground_area_in_m2 (Union[Unset, float]): Base area of the building in square metres.
        living_area_in_m2 (Union[Unset, float]): Total living space in square metres.
        cubic_volume_in_m3 (Union[Unset, float]): Total volume in cubic meters.
        number_of_apartments (Union[Unset, int]):
        number_of_floors (Union[Unset, int]):
        number_of_rooms (Union[Unset, float]):
        roof_area_in_m2 (Union[Unset, float]): total roof area in square meters.
        facade_area_in_m2 (Union[Unset, float]): Total facade area in square meters.
        human_identifier (Union[Unset, str]):
    """

    building_type: "ItemType"
    id: Union[Unset, UUID] = UNSET
    egid: Union[Unset, float] = UNSET
    plot_id: Union[Unset, UUID] = UNSET
    building_class: Union[Unset, "ItemType"] = UNSET
    height_in_meters: Union[Unset, float] = UNSET
    ground_area_in_m2: Union[Unset, float] = UNSET
    living_area_in_m2: Union[Unset, float] = UNSET
    cubic_volume_in_m3: Union[Unset, float] = UNSET
    number_of_apartments: Union[Unset, int] = UNSET
    number_of_floors: Union[Unset, int] = UNSET
    number_of_rooms: Union[Unset, float] = UNSET
    roof_area_in_m2: Union[Unset, float] = UNSET
    facade_area_in_m2: Union[Unset, float] = UNSET
    human_identifier: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        building_type = self.building_type.to_dict()

        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        egid = self.egid

        plot_id: Union[Unset, str] = UNSET
        if not isinstance(self.plot_id, Unset):
            plot_id = str(self.plot_id)

        building_class: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.building_class, Unset):
            building_class = self.building_class.to_dict()

        height_in_meters = self.height_in_meters

        ground_area_in_m2 = self.ground_area_in_m2

        living_area_in_m2 = self.living_area_in_m2

        cubic_volume_in_m3 = self.cubic_volume_in_m3

        number_of_apartments = self.number_of_apartments

        number_of_floors = self.number_of_floors

        number_of_rooms = self.number_of_rooms

        roof_area_in_m2 = self.roof_area_in_m2

        facade_area_in_m2 = self.facade_area_in_m2

        human_identifier = self.human_identifier

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "buildingType": building_type,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if egid is not UNSET:
            field_dict["egid"] = egid
        if plot_id is not UNSET:
            field_dict["plotId"] = plot_id
        if building_class is not UNSET:
            field_dict["buildingClass"] = building_class
        if height_in_meters is not UNSET:
            field_dict["heightInMeters"] = height_in_meters
        if ground_area_in_m2 is not UNSET:
            field_dict["groundAreaInM2"] = ground_area_in_m2
        if living_area_in_m2 is not UNSET:
            field_dict["livingAreaInM2"] = living_area_in_m2
        if cubic_volume_in_m3 is not UNSET:
            field_dict["cubicVolumeInM3"] = cubic_volume_in_m3
        if number_of_apartments is not UNSET:
            field_dict["numberOfApartments"] = number_of_apartments
        if number_of_floors is not UNSET:
            field_dict["numberOfFloors"] = number_of_floors
        if number_of_rooms is not UNSET:
            field_dict["numberOfRooms"] = number_of_rooms
        if roof_area_in_m2 is not UNSET:
            field_dict["roofAreaInM2"] = roof_area_in_m2
        if facade_area_in_m2 is not UNSET:
            field_dict["facadeAreaInM2"] = facade_area_in_m2
        if human_identifier is not UNSET:
            field_dict["humanIdentifier"] = human_identifier

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        building_type = ItemType.from_dict(d.pop("buildingType"))

        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        egid = d.pop("egid", UNSET)

        _plot_id = d.pop("plotId", UNSET)
        plot_id: Union[Unset, UUID]
        if isinstance(_plot_id, Unset):
            plot_id = UNSET
        else:
            plot_id = UUID(_plot_id)

        _building_class = d.pop("buildingClass", UNSET)
        building_class: Union[Unset, ItemType]
        if isinstance(_building_class, Unset):
            building_class = UNSET
        else:
            building_class = ItemType.from_dict(_building_class)

        height_in_meters = d.pop("heightInMeters", UNSET)

        ground_area_in_m2 = d.pop("groundAreaInM2", UNSET)

        living_area_in_m2 = d.pop("livingAreaInM2", UNSET)

        cubic_volume_in_m3 = d.pop("cubicVolumeInM3", UNSET)

        number_of_apartments = d.pop("numberOfApartments", UNSET)

        number_of_floors = d.pop("numberOfFloors", UNSET)

        number_of_rooms = d.pop("numberOfRooms", UNSET)

        roof_area_in_m2 = d.pop("roofAreaInM2", UNSET)

        facade_area_in_m2 = d.pop("facadeAreaInM2", UNSET)

        human_identifier = d.pop("humanIdentifier", UNSET)

        building = cls(
            building_type=building_type,
            id=id,
            egid=egid,
            plot_id=plot_id,
            building_class=building_class,
            height_in_meters=height_in_meters,
            ground_area_in_m2=ground_area_in_m2,
            living_area_in_m2=living_area_in_m2,
            cubic_volume_in_m3=cubic_volume_in_m3,
            number_of_apartments=number_of_apartments,
            number_of_floors=number_of_floors,
            number_of_rooms=number_of_rooms,
            roof_area_in_m2=roof_area_in_m2,
            facade_area_in_m2=facade_area_in_m2,
            human_identifier=human_identifier,
        )

        building.additional_properties = d
        return building

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
