from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.await_verified_response_result import AwaitVerifiedResponseResult

T = TypeVar("T", bound="AwaitVerifiedResponse")


@_attrs_define
class AwaitVerifiedResponse:
    """Request wait until files have been verified.

    Attributes:
        result (AwaitVerifiedResponseResult): Result of the operation
    """

    result: AwaitVerifiedResponseResult
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        result = self.result.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "result": result,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        result = AwaitVerifiedResponseResult(d.pop("result"))

        await_verified_response = cls(
            result=result,
        )

        await_verified_response.additional_properties = d
        return await_verified_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
