from collections.abc import Mapping
from typing import Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.attribute_type_data_type import AttributeTypeDataType
from ..types import UNSET, Unset

T = TypeVar("T", bound="AttributeType")


@_attrs_define
class AttributeType:
    """
    Attributes:
        id (Union[Unset, UUID]):
        code (Union[Unset, str]):
        name (Union[Unset, str]):
        description (Union[Unset, str]):
        data_type (Union[Unset, AttributeTypeDataType]):
    """

    id: Union[Unset, UUID] = UNSET
    code: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    description: Union[Unset, str] = UNSET
    data_type: Union[Unset, AttributeTypeDataType] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        code = self.code

        name = self.name

        description = self.description

        data_type: Union[Unset, str] = UNSET
        if not isinstance(self.data_type, Unset):
            data_type = self.data_type.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if code is not UNSET:
            field_dict["code"] = code
        if name is not UNSET:
            field_dict["name"] = name
        if description is not UNSET:
            field_dict["description"] = description
        if data_type is not UNSET:
            field_dict["dataType"] = data_type

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        code = d.pop("code", UNSET)

        name = d.pop("name", UNSET)

        description = d.pop("description", UNSET)

        _data_type = d.pop("dataType", UNSET)
        data_type: Union[Unset, AttributeTypeDataType]
        if isinstance(_data_type, Unset):
            data_type = UNSET
        else:
            data_type = AttributeTypeDataType(_data_type)

        attribute_type = cls(
            id=id,
            code=code,
            name=name,
            description=description,
            data_type=data_type,
        )

        attribute_type.additional_properties = d
        return attribute_type

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
