from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="AbstractUserContext")


@_attrs_define
class AbstractUserContext:
    """
    Attributes:
        external_ref (str):  Example: BankId.
        name (str):  Example: TestUC.
        description (Union[Unset, str]):  Example: Hier lege ich mein Hausdossier für das Wohnhaus ab.
        origin (Union[Unset, str]):  Example: rfu.
    """

    external_ref: str
    name: str
    description: Union[Unset, str] = UNSET
    origin: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        external_ref = self.external_ref

        name = self.name

        description = self.description

        origin = self.origin

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "externalRef": external_ref,
                "name": name,
            }
        )
        if description is not UNSET:
            field_dict["description"] = description
        if origin is not UNSET:
            field_dict["origin"] = origin

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        external_ref = d.pop("externalRef")

        name = d.pop("name")

        description = d.pop("description", UNSET)

        origin = d.pop("origin", UNSET)

        abstract_user_context = cls(
            external_ref=external_ref,
            name=name,
            description=description,
            origin=origin,
        )

        abstract_user_context.additional_properties = d
        return abstract_user_context

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
