"""Contains all the data models used in inputs/outputs"""

from .abstract_consent_invitation import AbstractConsentInvitation
from .abstract_consent_invitation_consent_scope import AbstractConsentInvitationConsentScope
from .abstract_invitation import AbstractInvitation
from .abstract_user_context import AbstractUserContext
from .address import Address
from .any_ import Any
from .apartment import Apartment
from .area import Area
from .attribute import Attribute
from .attribute_type import AttributeType
from .attribute_type_data_type import AttributeTypeDataType
from .await_verified_request import AwaitVerifiedRequest
from .await_verified_response import AwaitVerifiedResponse
from .await_verified_response_result import AwaitVerifiedResponseResult
from .building import Building
from .building_part import BuildingPart
from .calculation_result import CalculationResult
from .condition import Condition
from .consent import Consent
from .consent_consent_permission import ConsentConsentPermission
from .consent_consent_scope import ConsentConsentScope
from .consent_invitation import ConsentInvitation
from .consent_permission import ConsentPermission
from .coordinates import Coordinates
from .document import Document
from .energy_consumption import EnergyConsumption
from .energy_production import EnergyProduction
from .energy_type import EnergyType
from .entrance import Entrance
from .environment_impact import EnvironmentImpact
from .environment_impact_unit import EnvironmentImpactUnit
from .file_description import FileDescription
from .file_get_description import FileGetDescription
from .file_status import FileStatus
from .fit_out_standard import FitOutStandard
from .format_type import FormatType
from .get_all_files_response_200 import GetAllFilesResponse200
from .get_all_files_status_item import GetAllFilesStatusItem
from .get_owner_response_200 import GetOwnerResponse200
from .get_reod_v1_dictionary_group_id_code_cast_to import GetReodV1DictionaryGroupIdCodeCastTo
from .get_reod_v1_dictionary_group_id_code_identifier import GetReodV1DictionaryGroupIdCodeIdentifier
from .get_reod_v1_dictionary_group_id_code_order_by import GetReodV1DictionaryGroupIdCodeOrderBy
from .get_reod_v1_dictionary_group_id_code_response_200_item_type_0 import (
    GetReodV1DictionaryGroupIdCodeResponse200ItemType0,
)
from .get_reod_v1_dictionary_type_name_order_by import GetReodV1DictionaryTypeNameOrderBy
from .get_reod_v1_dictionary_type_name_response_200_item_type_1 import GetReodV1DictionaryTypeNameResponse200ItemType1
from .get_reod_v1_user_ctx_id_building_building_id_address_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdAddressResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_entrance_entrance_id_address_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdEntranceEntranceIdAddressResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_entrance_entrance_id_coordinates_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdEntranceEntranceIdCoordinatesResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_entrance_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdEntranceResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_inventory_inventory_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryInventoryIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_inventory_inventory_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryInventoryIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_inventory_inventory_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryInventoryIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_inventory_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_part_part_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartPartIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_part_part_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartPartIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_part_part_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartPartIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_part_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_inventory_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryInventoryIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_inventory_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryInventoryIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_inventory_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryInventoryIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_part_part_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartPartIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_part_part_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartPartIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_part_part_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartPartIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_part_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_valuation_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdValuationResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_apartment_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdApartmentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_coordinates_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdCoordinatesResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_entrance_entrance_id_address_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdEntranceEntranceIdAddressResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_entrance_entrance_id_coordinates_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdEntranceEntranceIdCoordinatesResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_entrance_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdEntranceResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_inventory_inventory_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdInventoryInventoryIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_inventory_inventory_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdInventoryInventoryIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_inventory_inventory_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdInventoryInventoryIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_inventory_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdInventoryResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_part_part_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_part_part_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdPartPartIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_part_part_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdPartPartIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_part_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdPartResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_inventory_inventory_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryInventoryIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_inventory_inventory_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryInventoryIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_inventory_inventory_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryInventoryIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_inventory_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_part_part_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartPartIdAttributeResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_part_part_id_document_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartPartIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_part_part_id_label_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartPartIdLabelResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_room_room_id_part_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartResponse200,
)
from .get_reod_v1_user_ctx_id_building_building_id_valuation_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdValuationResponse200,
)
from .get_reod_v1_user_ctx_id_building_response_200 import GetReodV1UserCtxIdBuildingResponse200
from .get_reod_v1_user_ctx_id_calculation_building_part_key_figure import (
    GetReodV1UserCtxIdCalculationBuildingPartKeyFigure,
)
from .get_reod_v1_user_ctx_id_calculation_energy_consumption_key_figure import (
    GetReodV1UserCtxIdCalculationEnergyConsumptionKeyFigure,
)
from .get_reod_v1_user_ctx_id_calculation_energy_production_key_figure import (
    GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
)
from .get_reod_v1_user_ctx_id_calculation_environment_impact_key_figure import (
    GetReodV1UserCtxIdCalculationEnvironmentImpactKeyFigure,
)
from .get_reod_v1_user_ctx_id_document_response_200 import GetReodV1UserCtxIdDocumentResponse200
from .get_reod_v1_user_ctx_id_history_object_id_response_200 import GetReodV1UserCtxIdHistoryObjectIdResponse200
from .get_reod_v1_user_ctx_id_history_object_id_revision_response_200 import (
    GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200,
)
from .get_reod_v1_user_ctx_id_plot_plot_id_area_area_id_document_response_200 import (
    GetReodV1UserCtxIdPlotPlotIdAreaAreaIdDocumentResponse200,
)
from .get_reod_v1_user_ctx_id_plot_plot_id_area_response_200 import GetReodV1UserCtxIdPlotPlotIdAreaResponse200
from .get_reod_v1_user_ctx_id_plot_plot_id_building_response_200 import GetReodV1UserCtxIdPlotPlotIdBuildingResponse200
from .get_reod_v1_user_ctx_id_plot_plot_id_document_response_200 import GetReodV1UserCtxIdPlotPlotIdDocumentResponse200
from .get_reod_v1_user_ctx_id_plot_plot_id_valuation_response_200 import (
    GetReodV1UserCtxIdPlotPlotIdValuationResponse200,
)
from .get_reod_v1_user_ctx_id_plot_response_200 import GetReodV1UserCtxIdPlotResponse200
from .group_info import GroupInfo
from .history_object_id import HistoryObjectId
from .history_object_id_status import HistoryObjectIdStatus
from .history_revision import HistoryRevision
from .history_revision_object_action import HistoryRevisionObjectAction
from .history_revision_request_action import HistoryRevisionRequestAction
from .inventory import Inventory
from .invitation import Invitation
from .invitation_status import InvitationStatus
from .invitation_type import InvitationType
from .item_type import ItemType
from .item_type_complex import ItemTypeComplex
from .key_object_value_number import KeyObjectValueNumber
from .key_object_value_number_key import KeyObjectValueNumberKey
from .key_string_value_string import KeyStringValueString
from .label import Label
from .label_type import LabelType
from .list_consent_invitation_response_200 import ListConsentInvitationResponse200
from .list_consent_response_200 import ListConsentResponse200
from .list_invitations_response_200 import ListInvitationsResponse200
from .list_objects_response_200 import ListObjectsResponse200
from .list_revisions_response_200 import ListRevisionsResponse200
from .list_user_context_response_200 import ListUserContextResponse200
from .owner import Owner
from .pagination_body import PaginationBody
from .pagination_meta_data import PaginationMetaData
from .physical_unit import PhysicalUnit
from .plot import Plot
from .quarantine_reason import QuarantineReason
from .register_for_transfer_response import RegisterForTransferResponse
from .ressource_chemical_substance import RessourceChemicalSubstance
from .room import Room
from .upload_description import UploadDescription
from .upload_description_upload_request_headers import UploadDescriptionUploadRequestHeaders
from .upload_request import UploadRequest
from .upload_request_mime_type import UploadRequestMimeType
from .user_context import UserContext
from .valuation import Valuation

__all__ = (
    "AbstractConsentInvitation",
    "AbstractConsentInvitationConsentScope",
    "AbstractInvitation",
    "AbstractUserContext",
    "Address",
    "Any",
    "Apartment",
    "Area",
    "Attribute",
    "AttributeType",
    "AttributeTypeDataType",
    "AwaitVerifiedRequest",
    "AwaitVerifiedResponse",
    "AwaitVerifiedResponseResult",
    "Building",
    "BuildingPart",
    "CalculationResult",
    "Condition",
    "Consent",
    "ConsentConsentPermission",
    "ConsentConsentScope",
    "ConsentInvitation",
    "ConsentPermission",
    "Coordinates",
    "Document",
    "EnergyConsumption",
    "EnergyProduction",
    "EnergyType",
    "Entrance",
    "EnvironmentImpact",
    "EnvironmentImpactUnit",
    "FileDescription",
    "FileGetDescription",
    "FileStatus",
    "FitOutStandard",
    "FormatType",
    "GetAllFilesResponse200",
    "GetAllFilesStatusItem",
    "GetOwnerResponse200",
    "GetReodV1DictionaryGroupIdCodeCastTo",
    "GetReodV1DictionaryGroupIdCodeIdentifier",
    "GetReodV1DictionaryGroupIdCodeOrderBy",
    "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
    "GetReodV1DictionaryTypeNameOrderBy",
    "GetReodV1DictionaryTypeNameResponse200ItemType1",
    "GetReodV1UserCtxIdBuildingBuildingIdAddressResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdEntranceEntranceIdAddressResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdEntranceEntranceIdCoordinatesResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdEntranceResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryInventoryIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryInventoryIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryInventoryIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdInventoryResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartPartIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartPartIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartPartIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdPartResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryInventoryIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryInventoryIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryInventoryIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartPartIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartPartIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartPartIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdPartResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdValuationResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdApartmentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdCoordinatesResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdEntranceEntranceIdAddressResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdEntranceEntranceIdCoordinatesResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdEntranceResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdInventoryInventoryIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdInventoryInventoryIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdInventoryInventoryIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdInventoryResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdPartPartIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdPartPartIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdPartResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryInventoryIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryInventoryIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryInventoryIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdInventoryResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartPartIdAttributeResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartPartIdDocumentResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartPartIdLabelResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdRoomRoomIdPartResponse200",
    "GetReodV1UserCtxIdBuildingBuildingIdValuationResponse200",
    "GetReodV1UserCtxIdBuildingResponse200",
    "GetReodV1UserCtxIdCalculationBuildingPartKeyFigure",
    "GetReodV1UserCtxIdCalculationEnergyConsumptionKeyFigure",
    "GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure",
    "GetReodV1UserCtxIdCalculationEnvironmentImpactKeyFigure",
    "GetReodV1UserCtxIdDocumentResponse200",
    "GetReodV1UserCtxIdHistoryObjectIdResponse200",
    "GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200",
    "GetReodV1UserCtxIdPlotPlotIdAreaAreaIdDocumentResponse200",
    "GetReodV1UserCtxIdPlotPlotIdAreaResponse200",
    "GetReodV1UserCtxIdPlotPlotIdBuildingResponse200",
    "GetReodV1UserCtxIdPlotPlotIdDocumentResponse200",
    "GetReodV1UserCtxIdPlotPlotIdValuationResponse200",
    "GetReodV1UserCtxIdPlotResponse200",
    "GroupInfo",
    "HistoryObjectId",
    "HistoryObjectIdStatus",
    "HistoryRevision",
    "HistoryRevisionObjectAction",
    "HistoryRevisionRequestAction",
    "Inventory",
    "Invitation",
    "InvitationStatus",
    "InvitationType",
    "ItemType",
    "ItemTypeComplex",
    "KeyObjectValueNumber",
    "KeyObjectValueNumberKey",
    "KeyStringValueString",
    "Label",
    "LabelType",
    "ListConsentInvitationResponse200",
    "ListConsentResponse200",
    "ListInvitationsResponse200",
    "ListObjectsResponse200",
    "ListRevisionsResponse200",
    "ListUserContextResponse200",
    "Owner",
    "PaginationBody",
    "PaginationMetaData",
    "PhysicalUnit",
    "Plot",
    "QuarantineReason",
    "RegisterForTransferResponse",
    "RessourceChemicalSubstance",
    "Room",
    "UploadDescription",
    "UploadDescriptionUploadRequestHeaders",
    "UploadRequest",
    "UploadRequestMimeType",
    "UserContext",
    "Valuation",
)
