from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.calculation_result import CalculationResult
from ...models.get_reod_v1_user_ctx_id_calculation_energy_production_key_figure import (
    GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
)
from ...types import UNSET, Response, Unset


def _get_kwargs(
    user_ctx_id: UUID,
    *,
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    key_figure: GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    params: dict[str, Any] = {}

    json_filter_by_type_id: Union[Unset, str] = UNSET
    if not isinstance(filter_by_type_id, Unset):
        json_filter_by_type_id = str(filter_by_type_id)
    params["filterByTypeId"] = json_filter_by_type_id

    params["filterByTypeCode"] = filter_by_type_code

    json_key_figure = key_figure.value
    params["keyFigure"] = json_key_figure

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/reod/v1/{user_ctx_id}/calculation/energy-production",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, CalculationResult]]:
    if response.status_code == 200:
        response_200 = CalculationResult.from_dict(response.json())

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, CalculationResult]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_ctx_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    key_figure: GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
    user_language: Union[Unset, str] = UNSET,
) -> Response[Union[Any, CalculationResult]]:
    """Get Calculation Results of EnergyProduction

     Return the CalculationResult for EnergyProduction.

    Args:
        user_ctx_id (UUID):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        key_figure (GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, CalculationResult]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        filter_by_type_id=filter_by_type_id,
        filter_by_type_code=filter_by_type_code,
        key_figure=key_figure,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_ctx_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    key_figure: GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, CalculationResult]]:
    """Get Calculation Results of EnergyProduction

     Return the CalculationResult for EnergyProduction.

    Args:
        user_ctx_id (UUID):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        key_figure (GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, CalculationResult]
    """

    return sync_detailed(
        user_ctx_id=user_ctx_id,
        client=client,
        filter_by_type_id=filter_by_type_id,
        filter_by_type_code=filter_by_type_code,
        key_figure=key_figure,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    user_ctx_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    key_figure: GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
    user_language: Union[Unset, str] = UNSET,
) -> Response[Union[Any, CalculationResult]]:
    """Get Calculation Results of EnergyProduction

     Return the CalculationResult for EnergyProduction.

    Args:
        user_ctx_id (UUID):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        key_figure (GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, CalculationResult]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        filter_by_type_id=filter_by_type_id,
        filter_by_type_code=filter_by_type_code,
        key_figure=key_figure,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_ctx_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    key_figure: GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, CalculationResult]]:
    """Get Calculation Results of EnergyProduction

     Return the CalculationResult for EnergyProduction.

    Args:
        user_ctx_id (UUID):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        key_figure (GetReodV1UserCtxIdCalculationEnergyProductionKeyFigure):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, CalculationResult]
    """

    return (
        await asyncio_detailed(
            user_ctx_id=user_ctx_id,
            client=client,
            filter_by_type_id=filter_by_type_id,
            filter_by_type_code=filter_by_type_code,
            key_figure=key_figure,
            user_language=user_language,
        )
    ).parsed
