import datetime
from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.get_reod_v1_user_ctx_id_history_object_id_revision_response_200 import (
    GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200,
)
from ...types import UNSET, Response, Unset


def _get_kwargs(
    user_ctx_id: UUID,
    object_id: UUID,
    *,
    size: Union[Unset, int] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    date_from: Union[Unset, datetime.datetime] = UNSET,
    date_to: Union[Unset, datetime.datetime] = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    params["size"] = size

    params["pageToken"] = page_token

    json_date_from: Union[Unset, str] = UNSET
    if not isinstance(date_from, Unset):
        json_date_from = date_from.isoformat()
    params["dateFrom"] = json_date_from

    json_date_to: Union[Unset, str] = UNSET
    if not isinstance(date_to, Unset):
        json_date_to = date_to.isoformat()
    params["dateTo"] = json_date_to

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/reod/v1/{user_ctx_id}/history/{object_id}/revision",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]:
    if response.status_code == 200:
        response_200 = GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200.from_dict(response.json())

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_ctx_id: UUID,
    object_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, int] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    date_from: Union[Unset, datetime.datetime] = UNSET,
    date_to: Union[Unset, datetime.datetime] = UNSET,
) -> Response[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]:
    """Get HistoryInfo

     Return an Array with history entries. You get details of the changes using /history/ref/{ref}.

    Args:
        user_ctx_id (UUID):
        object_id (UUID):
        size (Union[Unset, int]):
        page_token (Union[Unset, str]):
        date_from (Union[Unset, datetime.datetime]):
        date_to (Union[Unset, datetime.datetime]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        object_id=object_id,
        size=size,
        page_token=page_token,
        date_from=date_from,
        date_to=date_to,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_ctx_id: UUID,
    object_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, int] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    date_from: Union[Unset, datetime.datetime] = UNSET,
    date_to: Union[Unset, datetime.datetime] = UNSET,
) -> Optional[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]:
    """Get HistoryInfo

     Return an Array with history entries. You get details of the changes using /history/ref/{ref}.

    Args:
        user_ctx_id (UUID):
        object_id (UUID):
        size (Union[Unset, int]):
        page_token (Union[Unset, str]):
        date_from (Union[Unset, datetime.datetime]):
        date_to (Union[Unset, datetime.datetime]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]
    """

    return sync_detailed(
        user_ctx_id=user_ctx_id,
        object_id=object_id,
        client=client,
        size=size,
        page_token=page_token,
        date_from=date_from,
        date_to=date_to,
    ).parsed


async def asyncio_detailed(
    user_ctx_id: UUID,
    object_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, int] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    date_from: Union[Unset, datetime.datetime] = UNSET,
    date_to: Union[Unset, datetime.datetime] = UNSET,
) -> Response[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]:
    """Get HistoryInfo

     Return an Array with history entries. You get details of the changes using /history/ref/{ref}.

    Args:
        user_ctx_id (UUID):
        object_id (UUID):
        size (Union[Unset, int]):
        page_token (Union[Unset, str]):
        date_from (Union[Unset, datetime.datetime]):
        date_to (Union[Unset, datetime.datetime]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        object_id=object_id,
        size=size,
        page_token=page_token,
        date_from=date_from,
        date_to=date_to,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_ctx_id: UUID,
    object_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, int] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    date_from: Union[Unset, datetime.datetime] = UNSET,
    date_to: Union[Unset, datetime.datetime] = UNSET,
) -> Optional[Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]]:
    """Get HistoryInfo

     Return an Array with history entries. You get details of the changes using /history/ref/{ref}.

    Args:
        user_ctx_id (UUID):
        object_id (UUID):
        size (Union[Unset, int]):
        page_token (Union[Unset, str]):
        date_from (Union[Unset, datetime.datetime]):
        date_to (Union[Unset, datetime.datetime]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, GetReodV1UserCtxIdHistoryObjectIdRevisionResponse200]
    """

    return (
        await asyncio_detailed(
            user_ctx_id=user_ctx_id,
            object_id=object_id,
            client=client,
            size=size,
            page_token=page_token,
            date_from=date_from,
            date_to=date_to,
        )
    ).parsed
