from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.get_all_files_response_200 import GetAllFilesResponse200
from ...models.get_all_files_status_item import GetAllFilesStatusItem
from ...types import UNSET, Response, Unset


def _get_kwargs(
    user_context: UUID,
    *,
    status: Union[Unset, list[GetAllFilesStatusItem]] = UNSET,
    size: Union[Unset, float] = 20.0,
    page_token: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    json_status: Union[Unset, list[str]] = UNSET
    if not isinstance(status, Unset):
        json_status = []
        for status_item_data in status:
            status_item = status_item_data.value
            json_status.append(status_item)

    params["status"] = json_status

    params["size"] = size

    params["pageToken"] = page_token

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/file-manager/v1/{user_context}/files",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, GetAllFilesResponse200]]:
    if response.status_code == 200:
        response_200 = GetAllFilesResponse200.from_dict(response.json())

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 500:
        response_500 = cast(Any, None)
        return response_500
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, GetAllFilesResponse200]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_context: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    status: Union[Unset, list[GetAllFilesStatusItem]] = UNSET,
    size: Union[Unset, float] = 20.0,
    page_token: Union[Unset, str] = UNSET,
) -> Response[Union[Any, GetAllFilesResponse200]]:
    """Get All Files

     Return all available Files.

    Args:
        user_context (UUID):  Example: 7df13462-54d8-4fd7-a2e8-5e18754d4030.
        status (Union[Unset, list[GetAllFilesStatusItem]]):
        size (Union[Unset, float]):  Default: 20.0. Example: 1000.
        page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, GetAllFilesResponse200]]
    """

    kwargs = _get_kwargs(
        user_context=user_context,
        status=status,
        size=size,
        page_token=page_token,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_context: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    status: Union[Unset, list[GetAllFilesStatusItem]] = UNSET,
    size: Union[Unset, float] = 20.0,
    page_token: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, GetAllFilesResponse200]]:
    """Get All Files

     Return all available Files.

    Args:
        user_context (UUID):  Example: 7df13462-54d8-4fd7-a2e8-5e18754d4030.
        status (Union[Unset, list[GetAllFilesStatusItem]]):
        size (Union[Unset, float]):  Default: 20.0. Example: 1000.
        page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, GetAllFilesResponse200]
    """

    return sync_detailed(
        user_context=user_context,
        client=client,
        status=status,
        size=size,
        page_token=page_token,
    ).parsed


async def asyncio_detailed(
    user_context: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    status: Union[Unset, list[GetAllFilesStatusItem]] = UNSET,
    size: Union[Unset, float] = 20.0,
    page_token: Union[Unset, str] = UNSET,
) -> Response[Union[Any, GetAllFilesResponse200]]:
    """Get All Files

     Return all available Files.

    Args:
        user_context (UUID):  Example: 7df13462-54d8-4fd7-a2e8-5e18754d4030.
        status (Union[Unset, list[GetAllFilesStatusItem]]):
        size (Union[Unset, float]):  Default: 20.0. Example: 1000.
        page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, GetAllFilesResponse200]]
    """

    kwargs = _get_kwargs(
        user_context=user_context,
        status=status,
        size=size,
        page_token=page_token,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_context: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    status: Union[Unset, list[GetAllFilesStatusItem]] = UNSET,
    size: Union[Unset, float] = 20.0,
    page_token: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, GetAllFilesResponse200]]:
    """Get All Files

     Return all available Files.

    Args:
        user_context (UUID):  Example: 7df13462-54d8-4fd7-a2e8-5e18754d4030.
        status (Union[Unset, list[GetAllFilesStatusItem]]):
        size (Union[Unset, float]):  Default: 20.0. Example: 1000.
        page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, GetAllFilesResponse200]
    """

    return (
        await asyncio_detailed(
            user_context=user_context,
            client=client,
            status=status,
            size=size,
            page_token=page_token,
        )
    ).parsed
