from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.attribute_type import AttributeType
from ...models.format_type import FormatType
from ...models.get_reod_v1_dictionary_type_name_order_by import GetReodV1DictionaryTypeNameOrderBy
from ...models.get_reod_v1_dictionary_type_name_response_200_item_type_1 import (
    GetReodV1DictionaryTypeNameResponse200ItemType1,
)
from ...models.item_type import ItemType
from ...models.item_type_complex import ItemTypeComplex
from ...models.label_type import LabelType
from ...types import UNSET, Response, Unset


def _get_kwargs(
    name: str,
    *,
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    order_by: Union[Unset, GetReodV1DictionaryTypeNameOrderBy] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    params: dict[str, Any] = {}

    json_filter_by_group_id: Union[Unset, str] = UNSET
    if not isinstance(filter_by_group_id, Unset):
        json_filter_by_group_id = str(filter_by_group_id)
    params["filterByGroupId"] = json_filter_by_group_id

    params["filterByGroupCode"] = filter_by_group_code

    json_order_by: Union[Unset, str] = UNSET
    if not isinstance(order_by, Unset):
        json_order_by = order_by.value

    params["orderBy"] = json_order_by

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/reod/v1/dictionary/type/{name}",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]
        ],
    ]
]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:

            def _parse_response_200_item(
                data: object,
            ) -> Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]:
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_0 = ItemTypeComplex.from_dict(data)

                    return response_200_item_type_0
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_1 = GetReodV1DictionaryTypeNameResponse200ItemType1.from_dict(data)

                    return response_200_item_type_1
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_2 = AttributeType.from_dict(data)

                    return response_200_item_type_2
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_3 = ItemType.from_dict(data)

                    return response_200_item_type_3
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_4 = FormatType.from_dict(data)

                    return response_200_item_type_4
                except:  # noqa: E722
                    pass
                if not isinstance(data, dict):
                    raise TypeError()
                response_200_item_type_5 = LabelType.from_dict(data)

                return response_200_item_type_5

            response_200_item = _parse_response_200_item(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]
        ],
    ]
]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    name: str,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    order_by: Union[Unset, GetReodV1DictionaryTypeNameOrderBy] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Response[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]
        ],
    ]
]:
    """Get Type Items

     Return an Array with all entries of a specific type.

    Args:
        name (str):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        order_by (Union[Unset, GetReodV1DictionaryTypeNameOrderBy]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, list[Union['AttributeType', 'FormatType', 'GetReodV1DictionaryTypeNameResponse200ItemType1', 'ItemType', 'ItemTypeComplex', 'LabelType']]]]
    """

    kwargs = _get_kwargs(
        name=name,
        filter_by_group_id=filter_by_group_id,
        filter_by_group_code=filter_by_group_code,
        order_by=order_by,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    name: str,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    order_by: Union[Unset, GetReodV1DictionaryTypeNameOrderBy] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]
        ],
    ]
]:
    """Get Type Items

     Return an Array with all entries of a specific type.

    Args:
        name (str):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        order_by (Union[Unset, GetReodV1DictionaryTypeNameOrderBy]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, list[Union['AttributeType', 'FormatType', 'GetReodV1DictionaryTypeNameResponse200ItemType1', 'ItemType', 'ItemTypeComplex', 'LabelType']]]
    """

    return sync_detailed(
        name=name,
        client=client,
        filter_by_group_id=filter_by_group_id,
        filter_by_group_code=filter_by_group_code,
        order_by=order_by,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    name: str,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    order_by: Union[Unset, GetReodV1DictionaryTypeNameOrderBy] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Response[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]
        ],
    ]
]:
    """Get Type Items

     Return an Array with all entries of a specific type.

    Args:
        name (str):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        order_by (Union[Unset, GetReodV1DictionaryTypeNameOrderBy]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, list[Union['AttributeType', 'FormatType', 'GetReodV1DictionaryTypeNameResponse200ItemType1', 'ItemType', 'ItemTypeComplex', 'LabelType']]]]
    """

    kwargs = _get_kwargs(
        name=name,
        filter_by_group_id=filter_by_group_id,
        filter_by_group_code=filter_by_group_code,
        order_by=order_by,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    name: str,
    *,
    client: Union[AuthenticatedClient, Client],
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    order_by: Union[Unset, GetReodV1DictionaryTypeNameOrderBy] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "FormatType",
                "GetReodV1DictionaryTypeNameResponse200ItemType1",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
            ]
        ],
    ]
]:
    """Get Type Items

     Return an Array with all entries of a specific type.

    Args:
        name (str):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        order_by (Union[Unset, GetReodV1DictionaryTypeNameOrderBy]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, list[Union['AttributeType', 'FormatType', 'GetReodV1DictionaryTypeNameResponse200ItemType1', 'ItemType', 'ItemTypeComplex', 'LabelType']]]
    """

    return (
        await asyncio_detailed(
            name=name,
            client=client,
            filter_by_group_id=filter_by_group_id,
            filter_by_group_code=filter_by_group_code,
            order_by=order_by,
            user_language=user_language,
        )
    ).parsed
