from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PaginationMetadata")


@_attrs_define
class PaginationMetadata:
    """
    Attributes:
        total_count (Union[Unset, int]):
        result_count (Union[Unset, int]):
        total_pages (Union[Unset, int]):
        prev_page_token (Union[None, Unset, str]):
        next_page_token (Union[None, Unset, str]):
        last_page_token (Union[None, Unset, str]):
    """

    total_count: Union[Unset, int] = UNSET
    result_count: Union[Unset, int] = UNSET
    total_pages: Union[Unset, int] = UNSET
    prev_page_token: Union[None, Unset, str] = UNSET
    next_page_token: Union[None, Unset, str] = UNSET
    last_page_token: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        total_count = self.total_count

        result_count = self.result_count

        total_pages = self.total_pages

        prev_page_token: Union[None, Unset, str]
        if isinstance(self.prev_page_token, Unset):
            prev_page_token = UNSET
        else:
            prev_page_token = self.prev_page_token

        next_page_token: Union[None, Unset, str]
        if isinstance(self.next_page_token, Unset):
            next_page_token = UNSET
        else:
            next_page_token = self.next_page_token

        last_page_token: Union[None, Unset, str]
        if isinstance(self.last_page_token, Unset):
            last_page_token = UNSET
        else:
            last_page_token = self.last_page_token

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if total_count is not UNSET:
            field_dict["totalCount"] = total_count
        if result_count is not UNSET:
            field_dict["resultCount"] = result_count
        if total_pages is not UNSET:
            field_dict["totalPages"] = total_pages
        if prev_page_token is not UNSET:
            field_dict["prevPageToken"] = prev_page_token
        if next_page_token is not UNSET:
            field_dict["nextPageToken"] = next_page_token
        if last_page_token is not UNSET:
            field_dict["lastPageToken"] = last_page_token

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        total_count = d.pop("totalCount", UNSET)

        result_count = d.pop("resultCount", UNSET)

        total_pages = d.pop("totalPages", UNSET)

        def _parse_prev_page_token(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        prev_page_token = _parse_prev_page_token(d.pop("prevPageToken", UNSET))

        def _parse_next_page_token(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        next_page_token = _parse_next_page_token(d.pop("nextPageToken", UNSET))

        def _parse_last_page_token(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        last_page_token = _parse_last_page_token(d.pop("lastPageToken", UNSET))

        pagination_metadata = cls(
            total_count=total_count,
            result_count=result_count,
            total_pages=total_pages,
            prev_page_token=prev_page_token,
            next_page_token=next_page_token,
            last_page_token=last_page_token,
        )

        pagination_metadata.additional_properties = d
        return pagination_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
