from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="EnergyKpi")


@_attrs_define
class EnergyKpi:
    """
    Attributes:
        scope_1_plus_2_total_energy (Union[None, Unset, str]):
        scope_1_plus_2_total_energy_rating (Union[None, Unset, str]):
        scope_1_plus_2_building_shell (Union[None, Unset, str]):
        scope_1_plus_2_building_shell_rating (Union[None, Unset, str]):
        building_shell_total_consumption_m_wh_per_anno (Union[None, Unset, str]):
        building_shell_total_consumption_m_wh_per_anno_rating (Union[None, Unset, str]):
        building_shell_total_emission_kg_co2_eq_m2 (Union[None, Unset, str]):
        building_shell_total_emission_kg_co2_eq_m2_rating (Union[None, Unset, str]):
    """

    scope_1_plus_2_total_energy: Union[None, Unset, str] = UNSET
    scope_1_plus_2_total_energy_rating: Union[None, Unset, str] = UNSET
    scope_1_plus_2_building_shell: Union[None, Unset, str] = UNSET
    scope_1_plus_2_building_shell_rating: Union[None, Unset, str] = UNSET
    building_shell_total_consumption_m_wh_per_anno: Union[None, Unset, str] = UNSET
    building_shell_total_consumption_m_wh_per_anno_rating: Union[None, Unset, str] = UNSET
    building_shell_total_emission_kg_co2_eq_m2: Union[None, Unset, str] = UNSET
    building_shell_total_emission_kg_co2_eq_m2_rating: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        scope_1_plus_2_total_energy: Union[None, Unset, str]
        if isinstance(self.scope_1_plus_2_total_energy, Unset):
            scope_1_plus_2_total_energy = UNSET
        else:
            scope_1_plus_2_total_energy = self.scope_1_plus_2_total_energy

        scope_1_plus_2_total_energy_rating: Union[None, Unset, str]
        if isinstance(self.scope_1_plus_2_total_energy_rating, Unset):
            scope_1_plus_2_total_energy_rating = UNSET
        else:
            scope_1_plus_2_total_energy_rating = self.scope_1_plus_2_total_energy_rating

        scope_1_plus_2_building_shell: Union[None, Unset, str]
        if isinstance(self.scope_1_plus_2_building_shell, Unset):
            scope_1_plus_2_building_shell = UNSET
        else:
            scope_1_plus_2_building_shell = self.scope_1_plus_2_building_shell

        scope_1_plus_2_building_shell_rating: Union[None, Unset, str]
        if isinstance(self.scope_1_plus_2_building_shell_rating, Unset):
            scope_1_plus_2_building_shell_rating = UNSET
        else:
            scope_1_plus_2_building_shell_rating = self.scope_1_plus_2_building_shell_rating

        building_shell_total_consumption_m_wh_per_anno: Union[None, Unset, str]
        if isinstance(self.building_shell_total_consumption_m_wh_per_anno, Unset):
            building_shell_total_consumption_m_wh_per_anno = UNSET
        else:
            building_shell_total_consumption_m_wh_per_anno = self.building_shell_total_consumption_m_wh_per_anno

        building_shell_total_consumption_m_wh_per_anno_rating: Union[None, Unset, str]
        if isinstance(self.building_shell_total_consumption_m_wh_per_anno_rating, Unset):
            building_shell_total_consumption_m_wh_per_anno_rating = UNSET
        else:
            building_shell_total_consumption_m_wh_per_anno_rating = (
                self.building_shell_total_consumption_m_wh_per_anno_rating
            )

        building_shell_total_emission_kg_co2_eq_m2: Union[None, Unset, str]
        if isinstance(self.building_shell_total_emission_kg_co2_eq_m2, Unset):
            building_shell_total_emission_kg_co2_eq_m2 = UNSET
        else:
            building_shell_total_emission_kg_co2_eq_m2 = self.building_shell_total_emission_kg_co2_eq_m2

        building_shell_total_emission_kg_co2_eq_m2_rating: Union[None, Unset, str]
        if isinstance(self.building_shell_total_emission_kg_co2_eq_m2_rating, Unset):
            building_shell_total_emission_kg_co2_eq_m2_rating = UNSET
        else:
            building_shell_total_emission_kg_co2_eq_m2_rating = self.building_shell_total_emission_kg_co2_eq_m2_rating

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if scope_1_plus_2_total_energy is not UNSET:
            field_dict["scope1Plus2TotalEnergy"] = scope_1_plus_2_total_energy
        if scope_1_plus_2_total_energy_rating is not UNSET:
            field_dict["scope1Plus2TotalEnergyRating"] = scope_1_plus_2_total_energy_rating
        if scope_1_plus_2_building_shell is not UNSET:
            field_dict["scope1Plus2BuildingShell"] = scope_1_plus_2_building_shell
        if scope_1_plus_2_building_shell_rating is not UNSET:
            field_dict["scope1Plus2BuildingShellRating"] = scope_1_plus_2_building_shell_rating
        if building_shell_total_consumption_m_wh_per_anno is not UNSET:
            field_dict["buildingShellTotalConsumptionMWhPerAnno"] = building_shell_total_consumption_m_wh_per_anno
        if building_shell_total_consumption_m_wh_per_anno_rating is not UNSET:
            field_dict["buildingShellTotalConsumptionMWhPerAnnoRating"] = (
                building_shell_total_consumption_m_wh_per_anno_rating
            )
        if building_shell_total_emission_kg_co2_eq_m2 is not UNSET:
            field_dict["buildingShellTotalEmissionKgCO2EqM2"] = building_shell_total_emission_kg_co2_eq_m2
        if building_shell_total_emission_kg_co2_eq_m2_rating is not UNSET:
            field_dict["buildingShellTotalEmissionKgCO2EqM2Rating"] = building_shell_total_emission_kg_co2_eq_m2_rating

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)

        def _parse_scope_1_plus_2_total_energy(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        scope_1_plus_2_total_energy = _parse_scope_1_plus_2_total_energy(d.pop("scope1Plus2TotalEnergy", UNSET))

        def _parse_scope_1_plus_2_total_energy_rating(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        scope_1_plus_2_total_energy_rating = _parse_scope_1_plus_2_total_energy_rating(
            d.pop("scope1Plus2TotalEnergyRating", UNSET)
        )

        def _parse_scope_1_plus_2_building_shell(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        scope_1_plus_2_building_shell = _parse_scope_1_plus_2_building_shell(d.pop("scope1Plus2BuildingShell", UNSET))

        def _parse_scope_1_plus_2_building_shell_rating(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        scope_1_plus_2_building_shell_rating = _parse_scope_1_plus_2_building_shell_rating(
            d.pop("scope1Plus2BuildingShellRating", UNSET)
        )

        def _parse_building_shell_total_consumption_m_wh_per_anno(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        building_shell_total_consumption_m_wh_per_anno = _parse_building_shell_total_consumption_m_wh_per_anno(
            d.pop("buildingShellTotalConsumptionMWhPerAnno", UNSET)
        )

        def _parse_building_shell_total_consumption_m_wh_per_anno_rating(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        building_shell_total_consumption_m_wh_per_anno_rating = (
            _parse_building_shell_total_consumption_m_wh_per_anno_rating(
                d.pop("buildingShellTotalConsumptionMWhPerAnnoRating", UNSET)
            )
        )

        def _parse_building_shell_total_emission_kg_co2_eq_m2(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        building_shell_total_emission_kg_co2_eq_m2 = _parse_building_shell_total_emission_kg_co2_eq_m2(
            d.pop("buildingShellTotalEmissionKgCO2EqM2", UNSET)
        )

        def _parse_building_shell_total_emission_kg_co2_eq_m2_rating(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        building_shell_total_emission_kg_co2_eq_m2_rating = _parse_building_shell_total_emission_kg_co2_eq_m2_rating(
            d.pop("buildingShellTotalEmissionKgCO2EqM2Rating", UNSET)
        )

        energy_kpi = cls(
            scope_1_plus_2_total_energy=scope_1_plus_2_total_energy,
            scope_1_plus_2_total_energy_rating=scope_1_plus_2_total_energy_rating,
            scope_1_plus_2_building_shell=scope_1_plus_2_building_shell,
            scope_1_plus_2_building_shell_rating=scope_1_plus_2_building_shell_rating,
            building_shell_total_consumption_m_wh_per_anno=building_shell_total_consumption_m_wh_per_anno,
            building_shell_total_consumption_m_wh_per_anno_rating=building_shell_total_consumption_m_wh_per_anno_rating,
            building_shell_total_emission_kg_co2_eq_m2=building_shell_total_emission_kg_co2_eq_m2,
            building_shell_total_emission_kg_co2_eq_m2_rating=building_shell_total_emission_kg_co2_eq_m2_rating,
        )

        energy_kpi.additional_properties = d
        return energy_kpi

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
