from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="Certificates")


@_attrs_define
class Certificates:
    """
    Attributes:
        geak (Union[None, Unset, str]):
        minergie (Union[None, Unset, str]):
        snbs (Union[None, Unset, str]):
    """

    geak: Union[None, Unset, str] = UNSET
    minergie: Union[None, Unset, str] = UNSET
    snbs: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        geak: Union[None, Unset, str]
        if isinstance(self.geak, Unset):
            geak = UNSET
        else:
            geak = self.geak

        minergie: Union[None, Unset, str]
        if isinstance(self.minergie, Unset):
            minergie = UNSET
        else:
            minergie = self.minergie

        snbs: Union[None, Unset, str]
        if isinstance(self.snbs, Unset):
            snbs = UNSET
        else:
            snbs = self.snbs

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if geak is not UNSET:
            field_dict["geak"] = geak
        if minergie is not UNSET:
            field_dict["minergie"] = minergie
        if snbs is not UNSET:
            field_dict["snbs"] = snbs

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)

        def _parse_geak(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        geak = _parse_geak(d.pop("geak", UNSET))

        def _parse_minergie(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        minergie = _parse_minergie(d.pop("minergie", UNSET))

        def _parse_snbs(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        snbs = _parse_snbs(d.pop("snbs", UNSET))

        certificates = cls(
            geak=geak,
            minergie=minergie,
            snbs=snbs,
        )

        certificates.additional_properties = d
        return certificates

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
