from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="BuildingIdentificationItem")


@_attrs_define
class BuildingIdentificationItem:
    """
    Attributes:
        street_name (Union[None, Unset, str]):
        house_number (Union[None, Unset, str]):
        zip_code (Union[None, Unset, str]):
        city_name (Union[None, Unset, str]):
    """

    street_name: Union[None, Unset, str] = UNSET
    house_number: Union[None, Unset, str] = UNSET
    zip_code: Union[None, Unset, str] = UNSET
    city_name: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        street_name: Union[None, Unset, str]
        if isinstance(self.street_name, Unset):
            street_name = UNSET
        else:
            street_name = self.street_name

        house_number: Union[None, Unset, str]
        if isinstance(self.house_number, Unset):
            house_number = UNSET
        else:
            house_number = self.house_number

        zip_code: Union[None, Unset, str]
        if isinstance(self.zip_code, Unset):
            zip_code = UNSET
        else:
            zip_code = self.zip_code

        city_name: Union[None, Unset, str]
        if isinstance(self.city_name, Unset):
            city_name = UNSET
        else:
            city_name = self.city_name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if street_name is not UNSET:
            field_dict["streetName"] = street_name
        if house_number is not UNSET:
            field_dict["houseNumber"] = house_number
        if zip_code is not UNSET:
            field_dict["zipCode"] = zip_code
        if city_name is not UNSET:
            field_dict["cityName"] = city_name

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)

        def _parse_street_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        street_name = _parse_street_name(d.pop("streetName", UNSET))

        def _parse_house_number(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        house_number = _parse_house_number(d.pop("houseNumber", UNSET))

        def _parse_zip_code(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        zip_code = _parse_zip_code(d.pop("zipCode", UNSET))

        def _parse_city_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        city_name = _parse_city_name(d.pop("cityName", UNSET))

        building_identification_item = cls(
            street_name=street_name,
            house_number=house_number,
            zip_code=zip_code,
            city_name=city_name,
        )

        building_identification_item.additional_properties = d
        return building_identification_item

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
