from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.energy_class import EnergyClass
from ...models.get_api_products_v1_energyclass_egid_data_provider import GetApiProductsV1EnergyclassEgidDataProvider
from ...types import UNSET, Response, Unset


def _get_kwargs(
    egid: int,
    *,
    data_provider: Union[
        Unset, GetApiProductsV1EnergyclassEgidDataProvider
    ] = GetApiProductsV1EnergyclassEgidDataProvider.REMMS,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    params: dict[str, Any] = {}

    json_data_provider: Union[Unset, str] = UNSET
    if not isinstance(data_provider, Unset):
        json_data_provider = data_provider.value

    params["dataProvider"] = json_data_provider

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/api-products/v1/energyclass/{egid}",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Optional[EnergyClass]:
    if response.status_code == 200:
        response_200 = EnergyClass.from_dict(response.json())

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Response[EnergyClass]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    egid: int,
    *,
    client: Union[AuthenticatedClient, Client],
    data_provider: Union[
        Unset, GetApiProductsV1EnergyclassEgidDataProvider
    ] = GetApiProductsV1EnergyclassEgidDataProvider.REMMS,
    user_language: Union[Unset, str] = UNSET,
) -> Response[EnergyClass]:
    """
    Args:
        egid (int):  Example: 299033.
        data_provider (Union[Unset, GetApiProductsV1EnergyclassEgidDataProvider]):  Default:
            GetApiProductsV1EnergyclassEgidDataProvider.REMMS.
        user_language (Union[Unset, str]):  Example: deu.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[EnergyClass]
    """

    kwargs = _get_kwargs(
        egid=egid,
        data_provider=data_provider,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    egid: int,
    *,
    client: Union[AuthenticatedClient, Client],
    data_provider: Union[
        Unset, GetApiProductsV1EnergyclassEgidDataProvider
    ] = GetApiProductsV1EnergyclassEgidDataProvider.REMMS,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[EnergyClass]:
    """
    Args:
        egid (int):  Example: 299033.
        data_provider (Union[Unset, GetApiProductsV1EnergyclassEgidDataProvider]):  Default:
            GetApiProductsV1EnergyclassEgidDataProvider.REMMS.
        user_language (Union[Unset, str]):  Example: deu.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        EnergyClass
    """

    return sync_detailed(
        egid=egid,
        client=client,
        data_provider=data_provider,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    egid: int,
    *,
    client: Union[AuthenticatedClient, Client],
    data_provider: Union[
        Unset, GetApiProductsV1EnergyclassEgidDataProvider
    ] = GetApiProductsV1EnergyclassEgidDataProvider.REMMS,
    user_language: Union[Unset, str] = UNSET,
) -> Response[EnergyClass]:
    """
    Args:
        egid (int):  Example: 299033.
        data_provider (Union[Unset, GetApiProductsV1EnergyclassEgidDataProvider]):  Default:
            GetApiProductsV1EnergyclassEgidDataProvider.REMMS.
        user_language (Union[Unset, str]):  Example: deu.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[EnergyClass]
    """

    kwargs = _get_kwargs(
        egid=egid,
        data_provider=data_provider,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    egid: int,
    *,
    client: Union[AuthenticatedClient, Client],
    data_provider: Union[
        Unset, GetApiProductsV1EnergyclassEgidDataProvider
    ] = GetApiProductsV1EnergyclassEgidDataProvider.REMMS,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[EnergyClass]:
    """
    Args:
        egid (int):  Example: 299033.
        data_provider (Union[Unset, GetApiProductsV1EnergyclassEgidDataProvider]):  Default:
            GetApiProductsV1EnergyclassEgidDataProvider.REMMS.
        user_language (Union[Unset, str]):  Example: deu.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        EnergyClass
    """

    return (
        await asyncio_detailed(
            egid=egid,
            client=client,
            data_provider=data_provider,
            user_language=user_language,
        )
    ).parsed
