import os

import requests


# The response from the client credentials endpoint contains neither User information nor a refresh token
class TokenResponse:
    def __init__(self, json_data):
        self.access_token = json_data['access_token']
        self.expires_in = json_data['expires_in']
        self.token_type = json_data['token_type']

BASE_URL = os.getenv('BASE_URL')
CLIENT_ID = os.getenv('CLIENT_ID')
CLIENT_SECRET = os.getenv('CLIENT_SECRET')

AUTHORIZATION_SERVER_URL = BASE_URL + "/auth/v1/oauth2/authorize"
TOKEN_ENDPOINT_URL = BASE_URL + "/auth/v1/oauth2/token"

def client_credentials_flow() -> TokenResponse:
    # The server expects Client ID and Secret in the body, not as a Basic Authentication header
    response = requests.post(
        TOKEN_ENDPOINT_URL,
        data={
            "grant_type": "client_credentials",
            "client_id": CLIENT_ID,
            "client_secret": CLIENT_SECRET,
        },
    )

    token_response_json = response.json()
    return TokenResponse(token_response_json)
